/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.workflow.dto.PmAttendanceDto;

public class AttendanceRouteCardVo extends ApprovalMenuVo {

	private static final long serialVersionUID = 6002665600142279869L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/workflow/attendanceRouteCard.jsp";
	private static final String EXTRA_JS   = "/pub/workflow/js/attendanceRouteCard.js";
	private static final String EXTRA_CSS  = "/pub/workflow/css/attendanceRouteCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_APPROVAL_ATTENDANCE;

	// 萔
	public static final int MODE_INSERT		= 0;
	public static final int MODE_UPDATE		= 1;
	public static final int MODE_IMPOSSIBLE	= 2;

	// p[^
	public static final String PRM_HID_ROUTE_ID		= "hidRouteid";
	public static final String PRM_PLT_OFFICE 			= "pltOffice";
	public static final String PRM_PLT_SECTION			= "pltSection";
	public static final String PRM_TXT_K_CODE			= "txtKCode";
	public static final String PRM_PLT_ROUTE_CODE		= "pltRouteCode";
	public static final String PRM_PLT_DELETE			= "pltDelete";

	// tB[h
	private String hidRouteid;
	private String pltOffice;
	private String pltSection;
	private String txtKCode;
	private String pltRouteCode;
	private String pltDelete;

	// v_EXg
	public String[][] aryPltOffice;
	public String[][] aryPltSection;
	public String[][] aryPltRoute;
	public String[][] aryUser;
	public String[][] aryBelongSection;
	public String[][] aryBelongOffice;

	// tB[hyѐ
	public static final String NAM_OFFICE	 	= CommonConst.NAM_OFFICE;
	public static final String NAM_SECTION	 	= CommonConst.NAM_STATION;
	public static final String NAM_K_CODE     = CommonConst.NAM_K_CODE;
	public static final String NAM_ROUTE_CODE	= CommonConst.NAM_APPROVAL_ROUTE;
	public static final String NAM_DELETE		= CommonConst.NAM_DELETE_FLAG;

	public static final int    LEN_CODE = 10;

	public static final String REG_DELETE  = CommonConst.REG_DELETE;

	/**
	 * RXgN^
	 */
	public AttendanceRouteCardVo() {
		super();
		mode = MODE_INSERT;
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		setHidRouteid("");
		setPltSection("");
		setTxtKCode("");
		setPltRouteCode("");
		setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		hidRouteid		= request.getParameter(PRM_HID_ROUTE_ID);
		pltOffice 		= request.getParameter(PRM_PLT_OFFICE);
		pltSection		= request.getParameter(PRM_PLT_SECTION);
		txtKCode		= request.getParameter(PRM_TXT_K_CODE);
		pltRouteCode	= request.getParameter(PRM_PLT_ROUTE_CODE);
		pltDelete		= request.getParameter(PRM_PLT_DELETE);
	}

	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(PmAttendanceDto dto) {
		hidRouteid		= String.valueOf(dto.getRouteId());
		pltSection		= dto.getSCode();
		txtKCode		= dto.getKCode();
		pltRouteCode	= dto.getRtCode();
		pltOffice 		= dto.getJCode();
		pltDelete 		= String.valueOf(dto.getDeleteFlag());
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(PmAttendanceDto dto) {
		dto.setSCode(pltSection);
		dto.setKCode(txtKCode);
		dto.setRtCode(pltRouteCode);
		dto.setJCode(pltOffice);
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// 񒷊mF
		checkLength(txtKCode, LEN_CODE, NAM_K_CODE, PRM_TXT_K_CODE);
		if (txtKCode.length() != 0) {
			// R[h݊mF
			checkCodeExist(txtKCode, aryUser, NAM_K_CODE, PRM_TXT_K_CODE);
			// mF
			if (pltSection.length() != 0) {
				checkBelong(txtKCode, pltSection, aryBelongSection, NAM_K_CODE, PRM_TXT_K_CODE);
			}
			// ƏmF
			if (pltOffice.length() != 0) {
				checkBelong(txtKCode, pltOffice, aryBelongOffice, NAM_K_CODE, PRM_TXT_K_CODE);
			}
		} else if (pltSection.length() != 0 || pltOffice.length() != 0) {
			checkRequired(pltSection, NAM_SECTION, PRM_PLT_SECTION);
			checkRequired(pltOffice, NAM_OFFICE, PRM_PLT_OFFICE);
		} else {
			String errMsg = MospUtility.getMessage(msg, "WA1010", "");
			addErrMessage(errMsg);
			addErrField(PRM_TXT_K_CODE);
			addErrField(PRM_PLT_SECTION);
			isValid = false;
		}
		// ÓmFI
		endValidation();
	}

	/**
	 * mF
	 * @param kCode					mFΏێЈR[h
	 * @param targetBelongCode		mFΏۃR[h
	 * @param aryTarget				mFΏ۔z
	 * @param name 					mFΏۖ
	 * @param id 					mFΏۃtB[hID
	 * @throws MospException
	 */
	private void checkBelong(
			String kCode,
			String targetBelongCode,
			String[][] aryTarget,
			String name,
			String id
	) throws MospException {
		// ЈR[h̏mF
		if (!targetBelongCode.equals(util.getCodeName(kCode, aryTarget))) {
			String errMsg = MospUtility.getMessage(msg, CommonConst.MSG_TARGET_NOT_EXIST, name);
			addErrMessage(errMsg);
			addErrField(id);
			isValid = false;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String getHidRouteid() 		{ return hidRouteid		; }
	public String getPltOffice() 		{ return pltOffice		; }
	public String getPltSection() 		{ return pltSection		; }
	public String getTxtKCode() 		{ return txtKCode		; }
	public String getPltRouteCode() 	{ return pltRouteCode	; }
	public String getPltDelete() 		{ return pltDelete		; }

	public String getEscTxtKCode() 		{ return escapeHTML(txtKCode)	; }

	public void setHidRouteid		(String hidRouteid	) { this.hidRouteid 	= hidRouteid	; }
	public void setPltOffice		(String pltOffice	) { this.pltOffice 		= pltOffice		; }
	public void setPltSection		(String pltSection	) { this.pltSection 	= pltSection	; }
	public void setTxtKCode		(String txtKCode	) { this.txtKCode 		= txtKCode		; }
	public void setPltRouteCode	(String pltRouteCode) { this.pltRouteCode	= pltRouteCode	; }
	public void setPltDelete		(String pltDelete	) { this.pltDelete 		= pltDelete		; }

}
